﻿#encoding: UTF-8

import math
from PIL import ImageDraw, ImageFont, Image
from random import random
from datetime import datetime, timedelta
from time import gmtime, strftime

# definicje kolorow
czarny = (0,0,0)
blekitny=(155,249,255)
niebieski=(196,236,255)
szary=(51,51,51)
zielony=(58,202,27)
czerwony=(255,0,0)
zolty=(255,204,0)
bialy=(255,255,255)
ente_bialy = (192,192,192)
ente_zolty = (255,255,0)
ente_zielony = (0, 96, 0)
ente_czerwony = (224, 48, 48)
ente_szary = (64, 64, 64)
ente_fioletowy = (224, 48, 224)

class rozklad_ente_lusterka(abstractscreenrenderer):
	def __init__(self, state):
		self.tlo = None
		self.ente_main = None
		self.bootowanie = Image.open("./textures/tabor/python/ente_boot2.png")
		self.szukanie = Image.open("./textures/tabor/python/ente_szukanie_rozkladu.png")	
		self.error = Image.open("./textures/tabor/python/ente_error.png")
		self.error2 = Image.open("./textures/tabor/python/ente_error2.png")
		self.close1 = Image.open("./textures/tabor/python/ente_closing.png")
		self.close2 = Image.open("./textures/tabor/python/ente_close.png")
		self.close3 = Image.open("./textures/tabor/python/ente_close2.png")
		self.monitoring = Image.open("./textures/tabor/python/monitoring_ente.png")	
		self.slave = Image.open("./textures/tabor/python/ente_ezt_slave.png")			
		# wczytanie czcionki
		czcionka = "./fonts/verdana.ttf"
		self.font = ImageFont.truetype( czcionka, 20)
		self.sredni_font = ImageFont.truetype( czcionka, 17)
		self.maly_font = ImageFont.truetype( czcionka, 15)
		self.bardzo_maly_font = ImageFont.truetype( czcionka, 12)
		self.polduzy_font = ImageFont.truetype( czcionka, 27)
		self.fontv16b = ImageFont.truetype('./fonts/verdanab.ttf', 16)
		self.fontv20b = ImageFont.truetype('./fonts/verdanab.ttf', 20)
		self.ente = ImageFont.truetype('./fonts/arialbd.ttf', 23)
		self.ente2 = ImageFont.truetype('./fonts/arial.ttf', 23)
		self.ente3 = ImageFont.truetype('./fonts/arial.ttf', 19)
		self.ente4 = ImageFont.truetype('./fonts/arialbd.ttf', 18)
		self.arialbold14 = ImageFont.truetype('./fonts/arialbd.ttf', 14)
		self.konsola = ImageFont.truetype('./fonts/unifont.ttf', 20)
		self.konsola2 = ImageFont.truetype('./fonts/dos.ttf', 20)
		
		bootowanie2 = Image.open("./textures/tabor/python/ente_boot.png")
		self.boot2 = bootowanie2.resize((562, 370), Image.ANTIALIAS)	
		
		self.last_time_update = 0
		self.dzis = datetime.now().timetuple().tm_yday
		self.rok = datetime.now().year
		self.last_hour = 10
		self.aktyw_ente = 0
		self.aktyw_ente2 = 0
		self.nieaktyw_ente = -1
		self.awaria_ente = False
		self.awaria_ente2 = False
		self.woz = None # nazwa pojazdu		
		self.woz2 = None # nazwa pojazdu		
		self.woz3 = None # nazwa pojazdu
		self.console_cursor = False
		# 
		self.lustro_lp = False # czy przeladowano lustro pojazdu
		self.lustro_pp = False # czy przeladowano lustro pojazdu
		self.lustro_lt = False # czy przeladowano lustro pojazdu
		self.lustro_pt = False # czy przeladowano lustro pojazdu
		self.lustro_lp_active = False # czy zaladowano obrazek lustro pojazdu
		self.lustro_pp_active = False # czy zaladowano obrazek lustro pojazdu
		self.lustro_lt_active = False # czy zaladowano obrazek lustro pojazdu
		self.lustro_pt_active = False # czy zaladowano obrazek lustro pojazdu
		self.lustro_woz_przod = None # nazwa pojazdu
		self.lustro_woz_tyl = None # nazwa pojazdu
		self.lustro_pojazd_lp = Image.open("./textures/tabor/python/lusterka/brak_kamery.png") # .transpose(Image.FLIP_LEFT_RIGHT)
		self.lustro_pojazd_pp = Image.open("./textures/tabor/python/lusterka/brak_kamery.png") # .transpose(Image.FLIP_LEFT_RIGHT)
		self.lustro_pojazd_lt = Image.open("./textures/tabor/python/lusterka/brak_kamery.png")
		self.lustro_pojazd_pt = Image.open("./textures/tabor/python/lusterka/brak_kamery.png")
		self.lustro_podklad_lewo = None
		self.lustro_podklad_lewo_tor = None
		self.lustro_podklad_prawo = None
		self.lustro_podklad_lewo_peron = Image.open("./textures/tabor/python/lusterka/lewy_dwutor_peron.png")
		self.lustro_podklad_prawo_peron = Image.open("./textures/tabor/python/lusterka/prawy_peron.png")
		self.lustro_dwutor = False
		self.lustro_ilewozow = 0
		self.lustro_odometer_znikaniaperonu1 = 0
		self.lustro_odometer_znikaniaperonu2 = 0
		self.lustro_na_peronie = False
	#ekran rozkładu
		self.baseImage = Image.open("./textures/tabor/python/podklad_ente.png").convert("RGB")
		if tableShortMode:
			
			# ponadto zmieniamy tutaj (jednorazowo) dane tabeli dla AKL/AKM
			global tableSize
			tableSize = (632, 444)
			global tableRows
			tableRows = [0, 28, 88, 148, 422, 482, 514, 556, 588, 620]

		# wczytanie czcionki
		self.font0 = ImageFont.truetype('./fonts/times.ttf', 12)
		self.font0b = ImageFont.truetype('./fonts/timesbd.ttf', 12)
		self.font1 = ImageFont.truetype('./fonts/times.ttf', 14)
		self.font1b = ImageFont.truetype('./fonts/timesbd.ttf', 14)
		self.font2 = ImageFont.truetype('./fonts/times.ttf', 18)
		self.font2b = ImageFont.truetype('./fonts/timesbd.ttf', 18)
		self.font3 = ImageFont.truetype('./fonts/times.ttf', 20)
		self.font3b = ImageFont.truetype('./fonts/timesbd.ttf', 20)
		self.fontv0 = ImageFont.truetype('./fonts/verdana.ttf', 14)
		self.fontv0b = ImageFont.truetype('./fonts/verdanab.ttf', 14)
		self.fontv1 = ImageFont.truetype('./fonts/verdana.ttf', 28)
		self.fontv1b = ImageFont.truetype('./fonts/verdanab.ttf', 28)
		self.fontv2 = ImageFont.truetype('./fonts/verdana.ttf', 42)
		self.fontv2b = ImageFont.truetype('./fonts/verdanab.ttf', 42)


	def _render(self, state):
		cars1 = 0
		cars2 = 0
		cars3 = 0
		cars4 = 0
		
		for i in range (1, state['car_no'] + 1):
			x = state['code_'+str(i)]
			if x[0] == "1":
				cars1 += 1
			elif x[0] == "2":
				cars2 += 1
			elif x[0] == "3":
				cars3 += 1
			elif x[0] == "4":
				cars4 += 1
		if (cars1 >= 1 and cars1 <= 6):
			pojazdy = 1
			if (cars2 >= 2 and cars2 <= 6):
				pojazdy = 2
				if (cars3 > 0 and cars3 <= 6):	
					pojazdy = 3			
				
		if self.tlo == None:
			self.tlo = self.openimage(state["tex"])
		if self.ente_main == None:
			self.ente_main = self.openimage(state["tex2"])	
		dt=0
		tlo = self.tlo.copy()
		velocity = state['velocity']
		speed = float(velocity)
		if state['seconds'] != self.last_time_update:
			dt = state['seconds'] - self.last_time_update
			if dt < 0:
				dt+=60
			self.last_time_update = state['seconds']

		# czy rozklad jazdy istnieje - dane na gore bo potrzebuje
		timetableExists = not (state["trainnumber"] == "none" or state["trainnumber"] == "rozklad" or state["train_stationcount"] == 0)
		if state["train_atpassengerstop"]:
			self.lustro_odometer_znikaniaperonu1 = state["odometer"] + 0.1
			self.lustro_odometer_znikaniaperonu2 = self.lustro_odometer_znikaniaperonu1 + state["train_length"]*0.001
		

		if (state['battery'] + state['converter']):				
			czas = str(state['hours']) + ":" 
			if state['minutes']<10:
				czas = czas + "0" + str(state['minutes']) + ":"
			else:
				czas = czas + str(state['minutes']) + ":"
			if state['seconds']<10:
				czas = czas + "0" +str(state['seconds'])
			else:
				czas = czas + str(state['seconds'])
			
			czas2 = str(state['hours']) + ":" 
			if state['minutes']<10:
				czas2 = czas2 + "0" + str(state['minutes']) 
			else:
				czas2 = czas2 + str(state['minutes'])
			if self.last_hour == 23 and state['hours'] == 0:
				self.dzis = self.dzis+1 # wlasnie wybila polnoc
			self.last_hour = state['hours']
			data = datetime(self.rok, 1, 1) + timedelta(self.dzis - 1)
			data = data.strftime("%d/%m/%Y")
			cab = state['cab']				
	#rozkład jazdy
			baseImage = self.tlo.copy()
			# chcemy rysowac po teksturze pulpitu
			draw = ImageDraw.Draw(baseImage, "RGBA")
			self.woz = self.get_vehicle_name(state['car_name1'])
			self.woz2 = self.get_vehicle_name(state['car_name'+str(1+cars1)])
			self.woz3 = self.get_vehicle_name(state['car_name'+str(1+cars1+cars2)])
			
			# kabina
			if state["cabactive"]:
				if self.nieaktyw_ente >= 0:
					self.aktyw_ente = 0
					self.nieaktyw_ente = -1
				self.aktyw_ente += dt
			else:
				if self.aktyw_ente >= 96:
					self.nieaktyw_ente = 0
				elif self.aktyw_ente > 0:
					self.nieaktyw_ente = 50
				if self.aktyw_ente > 0:
					self.aktyw_ente = 0
			
			
			
			if self.nieaktyw_ente >= 0:
				baseImage.paste(self.baseImage, (0,0))
				
				self.nieaktyw_ente += dt
				if self.nieaktyw_ente < 2:
					baseImage.paste(self.close1, (0, 0))
					tableTextColor = (230, 230, 230)
					if cab == 1:
						self.print_center(draw, "Kabina A", 55,16, self.fontv20b, tableTextColor)
					if cab == -1:
						self.print_center(draw, "Kabina B", 55,16, self.fontv20b, tableTextColor)
					self.print_center(draw, czas, 732,16, self.fontv20b, tableTextColor)
				elif self.nieaktyw_ente < 7:
					baseImage.paste(self.close2, (0, 0))
				elif self.nieaktyw_ente < 9:
					baseImage.paste(self.close3, (0, 0))
				else:
					draw.rectangle(((0, 0), (798, 606)), fill = ente_szary)
					self.print_left(draw, "Debian GNU/Linux 6.0 terminal tty1", 1, 20, self.konsola, bialy)
					self.print_left(draw, "terminal login: " + ("_" if self.console_cursor else ""), 1, 60, self.konsola, bialy)
					self.console_cursor = not self.console_cursor
				
				tlo.paste(baseImage, (0,0))
			
			
			
			elif self.aktyw_ente > 0 and self.aktyw_ente < 96:
				baseImage.paste(self.baseImage, (0,0))
				# moze by tak przeniesc ekran monitoringu do osobnego skryptu?
				baseImage.paste(self.boot2, (int(state["monitor_x"]), int(state["monitor_y"])))
				
				if self.aktyw_ente < 80:
					console = []
					
					if self.aktyw_ente < 71:
						if self.aktyw_ente >= 4:
							for i in range(4):
								console.append({"text": "", "color": bialy})
							console.append({"text": "Loading, please wait...", "color": bialy})
						if self.aktyw_ente >= 26:
							console.append({"text": "cryptsetup: ROOT set up successfully", "color": bialy})
						if self.aktyw_ente >= 27:
							console.append({"text": "INIT: version 2.88 booting", "color": bialy})
							console.append({"text": "Using makefile-style concurrent boot in runlevel S.", "color": bialy})
						if self.aktyw_ente >= 28:
							console.append({"text": "Mounting emergency tmpfs on /tmp...done.", "color": bialy})
							console.append({"text": "Starting the hotplug events dispatcher: udevd.", "color": bialy})
							console.append({"text": "Synthesizing the initial hotplug events...", "color": bialy})
						if self.aktyw_ente >= 29:
							console.pop()
							console.append({"text": "Synthesizing the initial hotplug events...done.", "color": bialy})
							console.append({"text": "Waiting for /dev to be fully populated...done.", "color": bialy})
						if self.aktyw_ente >= 30:
							console.append({"text": "Setting parameters of disc: (none).", "color": bialy})
							console.append({"text": "Setting preliminary keymap...done.", "color": bialy})
							console.append({"text": "Activating swap...done.", "color": bialy})
							console.append({"text": "Checking root file system...fsck from util-linux-ng 2.17.2", "color": bialy})
							console.append({"text": "e2fsck 1.41.12 (17-May-2010)", "color": bialy})
							console.append({"text": "/dev/mapper/ROOT: clean, 27348/47104 files, 714424/753004 blocks", "color": bialy})
							console.append({"text": "done.", "color": bialy})
							console.append({"text": "Starting early crypto disks...USER (starting)...", "color": bialy})
						if self.aktyw_ente >= 53:
							console.append({"text": "done.", "color": bialy})
							console.append({"text": "Starting remaining crypto disks...done.", "color": bialy})
							console.append({"text": "Loading kernel modules...done.", "color": bialy})
							console.append({"text": "Cleaning up ifupdown....", "color": bialy})
							console.append({"text": "Setting up networking....", "color": bialy})
							console.append({"text": "Activating lvm and md swap...done.", "color": bialy})
						if self.aktyw_ente >= 54:
							console.append({"text": "Checking file systems...fsck from util-linux-ng 2.17.2", "color": bialy})
							console.append({"text": "e2fsck 1.14.12 (17-May-2010)", "color": bialy})
							console.append({"text": "/dev/sda1: clean, 223/5784 files, 9119/23072 blocks", "color": bialy})
							console.append({"text": "e2fsck 1.14.12 (17-May-2010)", "color": bialy})
							console.append({"text": "/dev/mapper/USER: clean, 2599/53784 files, 48746/214828 blocks", "color": bialy})
							console.append({"text": "done.", "color": bialy})
							console.append({"text": "Mounting local filesystems...done.", "color": bialy})
							console.append({"text": "Activating swapfile swap...done.", "color": bialy})
							console.append({"text": "Setting console screen modes.", "color": bialy})
							console.append({"text": "Skipping font and keymap setup (handled by console-setup).", "color": bialy})
						if self.aktyw_ente >= 55:
							console.append({"text": "Setting up console font and keymap..._", "color": bialy})
						if self.aktyw_ente >= 56:
							console.pop()
							console.append({"text": "Setting up console font and keymap...done.", "color": bialy})
							console.append({"text": "Setting kernel variables ...done.", "color": bialy})
						if self.aktyw_ente >= 57:
							console.append({"text": "Configuring network interfaces...done.", "color": bialy})
						
						if self.aktyw_ente >= 59:
							console.append({"text": "Starting portmap daemon....", "color": bialy})
							console.append({"text": "ENTE: System prebooting...", "color": niebieski})
							console.append({"text": "ENTE: Creating ramdisk...", "color": ente_zolty})
							console.append({"text": "ENTE: Ramdisk created", "color": ente_zolty})
							console.append({"text": "ENTE: Starting CAN...", "color": bialy})
						if self.aktyw_ente >= 60:
							console.append({"text": "ENTE: AVR restart...", "color": ente_zolty})
						if self.aktyw_ente >= 61:
							console.append({"text": "ENTE: reading ID...", "color": ente_zolty})
							console.append({"text": "ENTE: AVR ID = 1", "color": zielony})
							console.append({"text": "ENTE: Seting IP address..", "color": ente_zolty})
							console.append({"text": "ENTE: IP configuration done", "color": ente_zolty})
							console.append({"text": "ENTE: heater turned off", "color": ente_zolty})
						
						
						if self.aktyw_ente >= 64:
							console.append({"text": "ENTE: md5sum ente OK", "color": bialy})
							console.append({"text": "ENTE: checking AWIA...", "color": ente_zolty})
							console.append({"text": "ENTE: attempt: 1 from 10", "color": ente_zolty})
						
						if self.aktyw_ente >= 66:
							console.append({"text": "ENTE: AWIA available", "color": ente_zolty})
							console.append({"text": "ENTE: Synchronizing data...", "color": ente_czerwony})
						if self.aktyw_ente >= 67:
							console.append({"text": "ENTE: Synchronization ended", "color": ente_czerwony})
							console.append({"text": "ENTE: md5sum rsync OK", "color": bialy})
							console.append({"text": "PROC_TYPE", "color": bialy})
							console.append({"text": "X86", "color": bialy})
							console.append({"text": "TYPE OK", "color": bialy})
							console.append({"text": "VERSION_NO", "color": bialy})
							console.append({"text": "1", "color": bialy})
							console.append({"text": "VERSION OK", "color": bialy})
							console.append({"text": "END", "color": bialy})
							console.append({"text": "ENTE: End of preboot", "color": niebieski})
							console.append({"text": "INIT: Entering runlevel: 2", "color": bialy})
						if self.aktyw_ente >= 68:
							console.append({"text": "Using makefile-style concurrent boot in runlevel 2.", "color": bialy})
							console.append({"text": "Starting portmap daemon....", "color": bialy})
							console.append({"text": "Starting NFS common utilities: statd.", "color": bialy})
							console.append({"text": "Starting enhanced syslogd: rsyslogd.", "color": bialy})
							console.append({"text": "Starting periodic command scheduler: cron.", "color": bialy})
						if self.aktyw_ente >= 69:
							console.append({"text": "Starting OpenBSD Secure Shell server: sshd.", "color": bialy})
							console.append({"text": "ENTE: tbupddwu deamon started", "color": ente_fioletowy})
							console.append({"text": "ENTE: rc.local...", "color": bialy})
						
					if self.aktyw_ente >= 56:
						console.append({"text": "_" if self.console_cursor else "", "color": console[-1]["color"] if len(console) > 0 else bialy})
						self.console_cursor = not self.console_cursor
					
					
					
					#for i in range(30):
					#	console.append({"text": "This is a line ...     " + str(i), "color": bialy})
					
					cfont = self.konsola if self.aktyw_ente >= 55 else self.konsola2
					ccolor = czarny if self.aktyw_ente < 3 else ente_szary
					#if self.aktyw_ente == 72:
					#	ccolor = bialy
					
					
					
					draw.rectangle(((0, 0), (798, 606)), fill = ccolor)
					
					for i in range(len(console)):
						y = (i - max(len(console) - 30, 0)) * 20
						if y < -15:
							continue
						line = console[i]
						self.print_left(draw, line["text"], 1, y, cfont, line["color"])
				
				elif self.aktyw_ente < 81:
					draw.rectangle(((0, 0), (798, 606)), fill = bialy)
				elif self.aktyw_ente < 84:
					draw.rectangle(((0, 0), (798, 606)), fill = ente_szary)
				elif self.aktyw_ente < 89:
					draw.rectangle(((0, 0), (798, 606)), fill = bialy)
				elif self.aktyw_ente < 95:
					baseImage.paste(self.bootowanie, (0,0))
					if self.aktyw_ente >= 90:
						self.print_center(draw, "Panel operatorski: 1.0.14.0 Jul  9 2019 08:21:10   Qt: 4.7.0", 399, 20, self.maly_font, czarny)
				else:
					draw.rectangle(((0, 0), (798, 606)), fill = ente_szary)
				
				tlo.paste(baseImage, (0,0))
			
			
			
			elif self.aktyw_ente >= 96:
				if self.lustro_podklad_lewo == None and self.lustro_podklad_lewo_tor == None and self.lustro_podklad_prawo == None:
					if self.dzis >= 65 and self.dzis < 252:
						self.lustro_podklad_lewo = Image.open("./textures/tabor/python/lusterka/lewy_pusto_lato.png")
						self.lustro_podklad_lewo_tor = Image.open("./textures/tabor/python/lusterka/lewy_dwutor_lato.png")
						self.lustro_podklad_prawo = Image.open("./textures/tabor/python/lusterka/prawy_pusto_lato.png")
					elif self.dzis >= 252 and self.dzis < 341:
						self.lustro_podklad_lewo = Image.open("./textures/tabor/python/lusterka/lewy_pusto_jesien.png")
						self.lustro_podklad_lewo_tor = Image.open("./textures/tabor/python/lusterka/lewy_dwutor_jesien.png")
						self.lustro_podklad_prawo = Image.open("./textures/tabor/python/lusterka/prawy_pusto_jesien.png")
					else:
						self.lustro_podklad_lewo = Image.open("./textures/tabor/python/lusterka/lewy_pusto.png")
						self.lustro_podklad_lewo_tor = Image.open("./textures/tabor/python/lusterka/lewy_dwutor.png")
						self.lustro_podklad_prawo = Image.open("./textures/tabor/python/lusterka/prawy_pusto.png")
				baseImage.paste(self.baseImage, (0,0))
				baseImage.paste(self.monitoring, (int(state["monitor_x"]), int(state["monitor_y"])))
				czyladowanie = True
				if pojazdy != self.lustro_ilewozow:
					self.lustro_ilewozow = pojazdy
					self.lustro_lp = False # czy przeladowano lustro pojazdu
					self.lustro_pp = False # czy przeladowano lustro pojazdu
					self.lustro_lt = False # czy przeladowano lustro pojazdu
					self.lustro_pt = False # czy przeladowano lustro pojazdu
					self.lustro_woz_przod = self.woz
					self.lustro_woz_tyl = self.woz
					if pojazdy == 2:
						self.lustro_woz_tyl = self.woz2
					if pojazdy == 3:
						self.lustro_woz_tyl = self.woz3
					if pojazdy > 3:
						self.lustro_woz_tyl = "none"

				if czyladowanie and (self.lustro_lp == False):
					czyladowanie = False
					try:	
						self.lustro_pojazd_lp = Image.open("./textures/tabor/python/lusterka/"+self.lustro_woz_przod+"_lewy.png").transpose(Image.FLIP_LEFT_RIGHT)
						self.lustro_lp_active = True
					except:
						pass
					finally:
						self.lustro_lp = True
				if czyladowanie and (self.lustro_pp == False):
					czyladowanie = False
					try:
						self.lustro_pojazd_pp = Image.open("./textures/tabor/python/lusterka/"+self.lustro_woz_przod+"_prawy.png").transpose(Image.FLIP_LEFT_RIGHT)
						self.lustro_pp_active = True
					except:
						pass
					finally:
						self.lustro_pp = True
				if czyladowanie and (self.lustro_lt == False):
					czyladowanie = False
					try:	
						self.lustro_pojazd_lt = Image.open("./textures/tabor/python/lusterka/"+self.lustro_woz_tyl+"_prawy.png")
						self.lustro_lt_active = True
					except:
						pass
					finally:
						self.lustro_lt = True
				if czyladowanie and (self.lustro_pt == False):
					czyladowanie = False
					try:
						self.lustro_pojazd_pt = Image.open("./textures/tabor/python/lusterka/"+self.lustro_woz_tyl+"_lewy.png")
						self.lustro_pt_active = True
					except:
						pass
					finally:
						self.lustro_pt = True
				## podkladki jedno lub dwutorowe
				if (timetableExists and state["train_station" + str(state["train_stationstart"]) + "_tracks"] >= 1):
					baseImage.paste(self.lustro_podklad_lewo_tor, (int(state["monitor_x"]), int(state["monitor_y"])))
					if state["train_atpassengerstop"] or (self.lustro_odometer_znikaniaperonu1 > state["odometer"]):
						baseImage.paste(self.lustro_podklad_lewo_peron, (int(state["monitor_x"]), int(state["monitor_y"])),self.lustro_podklad_lewo_peron)
					baseImage.paste(self.lustro_podklad_lewo_tor, (int(state["monitor_x"]), int(state["monitor_y"])+186))
					if state["train_atpassengerstop"] or (self.lustro_odometer_znikaniaperonu2 > state["odometer"]):
						baseImage.paste(self.lustro_podklad_lewo_peron, (int(state["monitor_x"]), int(state["monitor_y"])+186),self.lustro_podklad_lewo_peron)
				else:
					baseImage.paste(self.lustro_podklad_lewo, (int(state["monitor_x"]), int(state["monitor_y"])))
					baseImage.paste(self.lustro_podklad_lewo, (int(state["monitor_x"]), int(state["monitor_y"])+186))
				baseImage.paste(self.lustro_podklad_prawo, (int(state["monitor_x"])+281, int(state["monitor_y"])))
				if state["train_atpassengerstop"] or (self.lustro_odometer_znikaniaperonu1 > state["odometer"]):
					baseImage.paste(self.lustro_podklad_prawo_peron, (int(state["monitor_x"])+281, int(state["monitor_y"])),self.lustro_podklad_prawo_peron)
				baseImage.paste(self.lustro_podklad_prawo, (int(state["monitor_x"])+281, int(state["monitor_y"])+186))
				if state["train_atpassengerstop"] or (self.lustro_odometer_znikaniaperonu2 > state["odometer"]):
					baseImage.paste(self.lustro_podklad_prawo_peron, (int(state["monitor_x"])+281, int(state["monitor_y"])+186),self.lustro_podklad_prawo_peron)

				baseImage.paste(self.lustro_pojazd_lp, (int(state["monitor_x"]), int(state["monitor_y"])),self.lustro_pojazd_lp)
				baseImage.paste(self.lustro_pojazd_pp, (int(state["monitor_x"])+281, int(state["monitor_y"])),self.lustro_pojazd_pp)
				baseImage.paste(self.lustro_pojazd_lt, (int(state["monitor_x"]), int(state["monitor_y"])+186),self.lustro_pojazd_lt)
				baseImage.paste(self.lustro_pojazd_pt, (int(state["monitor_x"])+281, int(state["monitor_y"])+186),self.lustro_pojazd_pt)
				if state["light_level"] < 1:
					ciemnosc = (1 - state["light_level"]) * 255
					lustro_ciemnosc = Image.new('RGBA', (281,186), (60,60,60,0))
					draw_ciemnosc = ImageDraw.Draw(lustro_ciemnosc)
					draw_ciemnosc.rectangle(((0, 0), (282, 187)), fill=(60,60,60,int(ciemnosc)))
					if self.lustro_lp_active:
						baseImage.paste(lustro_ciemnosc, (int(state["monitor_x"]), int(state["monitor_y"])),lustro_ciemnosc)
					if self.lustro_pp_active:
						baseImage.paste(lustro_ciemnosc, (int(state["monitor_x"])+281, int(state["monitor_y"])),lustro_ciemnosc)				
					if self.lustro_lt_active:
						baseImage.paste(lustro_ciemnosc, (int(state["monitor_x"]), int(state["monitor_y"])+186),lustro_ciemnosc)
					if self.lustro_pt_active:
						baseImage.paste(lustro_ciemnosc, (int(state["monitor_x"])+281, int(state["monitor_y"])+186),lustro_ciemnosc)

				if self.lustro_lp_active:
					if state["light_level"] < 1:
						monitoring1 = (204,204,204)
					else:
						monitoring1 = (30,30,30)
				else:
					monitoring1 = (204,204,204)
				if self.lustro_pp_active:
					if state["light_level"] < 1:
						monitoring2 = (204,204,204)
					else:
						monitoring2 = (30,30,30)
				else:
					monitoring2 = (204,204,204)
				if self.lustro_lt_active:
					if state["light_level"] < 1:
						monitoring3 = (204,204,204)
					else:
						monitoring3 = (30,30,30)
				else:
					monitoring3 = (204,204,204)
				if self.lustro_pt_active:
					if state["light_level"] < 1:
						monitoring4 = (204,204,204)
					else:
						monitoring4 = (30,30,30)
				else:
					monitoring4 = (204,204,204)
					
						
				self.print_center(draw, self.woz , int(state["monitor_x"])+155, int(state["monitor_y"])+170, self.arialbold14, monitoring1)
				self.print_center(draw, data, int(state["monitor_x"])+45, int(state["monitor_y"])+15, self.arialbold14, monitoring1)
				self.print_center(draw, czas, int(state["monitor_x"])+125, int(state["monitor_y"])+15, self.arialbold14, monitoring1)
							
				self.print_center(draw, self.woz , int(state["monitor_x"])+155+284, int(state["monitor_y"])+170, self.arialbold14, monitoring2)
				self.print_center(draw, data, int(state["monitor_x"])+45+284, int(state["monitor_y"])+15, self.arialbold14, monitoring2)
				self.print_center(draw, czas, int(state["monitor_x"])+125+284, int(state["monitor_y"])+15, self.arialbold14, monitoring2)	
				

				self.print_center(draw, data, int(state["monitor_x"])+45, int(state["monitor_y"])+15+185, self.arialbold14, monitoring3)
				self.print_center(draw, czas, int(state["monitor_x"])+125, int(state["monitor_y"])+15+185, self.arialbold14, monitoring3)	
				

				self.print_center(draw, data, int(state["monitor_x"])+45+284, int(state["monitor_y"])+15+185, self.arialbold14, monitoring4)
				self.print_center(draw, czas, int(state["monitor_x"])+125+284, int(state["monitor_y"])+15+185, self.arialbold14, monitoring4)					

				if pojazdy == 1:
					self.print_center(draw, self.woz , int(state["monitor_x"])+155+284, int(state["monitor_y"])+170+185, self.arialbold14, monitoring3)
					self.print_center(draw, self.woz , int(state["monitor_x"])+155, int(state["monitor_y"])+170+185, self.arialbold14, monitoring4)

				if pojazdy == 2:
					self.print_center(draw, self.woz2 , int(state["monitor_x"])+155+284, int(state["monitor_y"])+170+185, self.arialbold14, monitoring3)
					self.print_center(draw, self.woz2 , int(state["monitor_x"])+155, int(state["monitor_y"])+170+185, self.arialbold14, monitoring4)

				if pojazdy == 3:
					self.print_center(draw, self.woz3 , int(state["monitor_x"])+155+284, int(state["monitor_y"])+170+185, self.arialbold14, monitoring3)
					self.print_center(draw, self.woz3 , int(state["monitor_x"])+155, int(state["monitor_y"])+170+185, self.arialbold14, monitoring4)
				
				if (cab == 1): 
					self.print_center(draw, "Lust A_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171, self.arialbold14, monitoring1)
					self.print_center(draw, "Lust A_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171, self.arialbold14, monitoring2)
					if pojazdy == 1 and cars1 == 2 or pojazdy == 2 and cars2 == 2 or pojazdy == 3 and cars3 == 2:
						self.print_center(draw, "Lust B_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171+185, self.arialbold14, monitoring1)
						self.print_center(draw, "Lust B_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171+185, self.arialbold14, monitoring2)
					if pojazdy == 1 and cars1 == 3 or pojazdy == 2 and cars2 == 3 or pojazdy == 3 and cars3 == 2:
						self.print_center(draw, "Lust C_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171+185, self.arialbold14, monitoring1)
						self.print_center(draw, "Lust C_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171+185, self.arialbold14, monitoring2)
					if pojazdy == 1 and cars1 == 4 or pojazdy == 2 and cars2 == 4 or pojazdy == 3 and cars3 == 2:
						self.print_center(draw, "Lust D_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171+185, self.arialbold14, monitoring1)
						self.print_center(draw, "Lust D_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171+185, self.arialbold14, monitoring2)
					if pojazdy == 1 and cars1 == 5 or pojazdy == 2 and cars2 == 5 or pojazdy == 3 and cars3 == 2:
						self.print_center(draw, "Lust E_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171+185, self.arialbold14, monitoring1)
						self.print_center(draw, "Lust E_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171+185, self.arialbold14, monitoring2)
					if pojazdy == 1 and cars1 == 6 or pojazdy == 2 and cars2 == 6 or pojazdy == 3 and cars3 == 2:
						self.print_center(draw, "Lust F_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171+185, self.arialbold14, monitoring1)
						self.print_center(draw, "Lust F_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171+185, self.arialbold14, monitoring2)					
				else:	
					self.print_center(draw, "Lust A_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171+185, self.arialbold14, monitoring3)
					self.print_center(draw, "Lust A_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171+185, self.arialbold14, monitoring4)					
					if cars1 == 2:
						self.print_center(draw, "Lust B_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171, self.arialbold14, monitoring3)
						self.print_center(draw, "Lust B_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171, self.arialbold14, monitoring4)
					if cars1 == 3:
						self.print_center(draw, "Lust C_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171, self.arialbold14, monitoring3)
						self.print_center(draw, "Lust C_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171, self.arialbold14, monitoring4)
					if cars1 == 4:
						self.print_center(draw, "Lust D_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171, self.arialbold14, monitoring3)
						self.print_center(draw, "Lust D_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171, self.arialbold14, monitoring4)
					if cars1 == 5:
						self.print_center(draw, "Lust E_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171, self.arialbold14, monitoring3)
						self.print_center(draw, "Lust E_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171, self.arialbold14, monitoring4)
					if cars1 == 6:
						self.print_center(draw, "Lust F_L" , int(state["monitor_x"])+234, int(state["monitor_y"])+171, self.arialbold14, monitoring3)
						self.print_center(draw, "Lust F_P" , int(state["monitor_x"])+234+284, int(state["monitor_y"])+171, self.arialbold14, monitoring4)
						
				
				#if (state['light_level']<0.325):
				tableColor = (0,0,0)
				tableTextColor = (230, 230, 230)
				#else:
					#tableColor = (210, 210, 210)
					#tableTextColor = (0,0,0)
				#	tableColor = (0,0,0)
				#	tableTextColor = (210, 210, 210)

				### dane ###
				# uwaga: wiekszosc globali zostala przeniesiona nizej, tutaj zostaja te ktore musza byc przeliczane co klatke
				global globalState
				globalState = state # state nie jest globalem, wiec musimy go skopiowac

				# czy rozklad jazdy istnieje - dane na gore bo potrzebuje

				global tableTrainName
				if timetableExists and tableTrainName != state["trainnumber"]: # gdy nastapila zmiana rozkladu (a takze przy wczytaniu) odswiezamy dane rozkladu
					tableTrainName = state["trainnumber"]
					prepareTableData()
					self.awaria_ente = random() < 0.005
					self.awaria_ente2 = random() < 0.005	
					self.aktyw_ente2 = 0		

				# kalkulacja zielonej kropki
				global tableGPSIndex
				if state["train_atpassengerstop"]:
					tableGPSIndex = state["train_stationstart"]
				if tableGPSIndex < state["train_stationstart"]:
					tableGPSIndex = 0
				### gorny panel ###
				self.print_center(draw, u"Rozkład Jazdy " + tableTrainName, 408,22, self.fontv20b, tableTextColor)
				self.print_center(draw, "1/2", 748,87, self.fontv0b, tableTextColor)



				# do odjazdu i takie tam
				if timetableExists:	
					# klon z SRG bo tak
					numeraktualnejstacji = 0
					numerostatniejstacji = 0
					nazwastacji = ""
					nazwastacjidocelowej = ""

					ah = 0
					am = 0
					dh = 0
					dm = 0

					stacje = []
					teraz = False

					for i in range(state["train_stationcount"]):
						if i + 1 == state["train_stationstart"]:
							teraz = True
						if state["train_station" + str(i + 1) + "_ah"] != -1:
							stacje.append(state["train_station" + str(i + 1) + "_name"])
							if teraz:
								numeraktualnejstacji = len(stacje) - 1 # stacje na sterowniku numerowane sa od 0
								nazwastacji = stacje[-1].replace("_", " ")
								ah = state["train_station" + str(i + 1) + "_ah"]
								am = state["train_station" + str(i + 1) + "_am"]
								dh = state["train_station" + str(i + 1) + "_dh"]
								dm = state["train_station" + str(i + 1) + "_dm"]
								teraz = False

					if state["train_stationcount"] > 0:
						numerostatniejstacji = len(stacje) - 1
						nazwastacjidocelowej = stacje[-1].replace("_", " ")



					# w sekundach
					timeToDeparture = int(journeyTimeSecs(state["hours"], state["minutes"], state["seconds"], dh, dm, 0))
					delay = 0
					if timeToDeparture >= 0:
						timeToDeparture = timeTextSecs(timeToDeparture / 3600, (timeToDeparture / 60) % 60, timeToDeparture % 60)
					else:
						delay = -timeToDeparture / 60
						timeToDeparture = -1

					nextTimeD = timeText(dh, dm)
					nextTimeA = nextTimeD
					if ah != -1:
						nextTimeA = timeText(ah, am)

					text1 = ""
					text2 = ""
					text3 = ""

					if tableGPSIndex == 0:
						text1 = u"Następny postój: "
					else:
						text1 = u"Stacja: "
					text1 += nazwastacji.upper() + u" p." + nextTimeA + u" o." + nextTimeD

					if tableGPSIndex == 0:
						text2 = u"Do odjazdu: ---"
					elif timeToDeparture == -1:
						text2 = u"Odjazd"
					else:
						text2 = u"Do odjazdu: " + timeToDeparture

					text3 = u"Opóźnienie: " + str(delay) + " min."

					text1c = tableTextColor
					text2c = tableTextColor
					text3c = tableTextColor
					if tableGPSIndex > 0 and timeToDeparture == -1:
						text2c = ente_zielony
					if delay > 0:
						text3c = ente_czerwony

					self.print_left(draw, text1, 8, 52, self.fontv20b, text1c)
					self.print_left(draw, text2, 8, 76, self.fontv20b, text2c)
					self.print_left(draw, text3, 358, 76, self.fontv20b, text3c)

				### tabela ###
				# robimy nowa teksture dla tabeli, zeby nie wykroczyla poza zakres i nie wyjechala na sasiednie ekrany
				tableImage = Image.new("RGB", tableSize)
				tableDraw = ImageDraw.Draw(tableImage)
				tableDraw.rectangle((0, 0, tableSize[0], tableSize[1]), fill = tableColor)

			
				
				if timetableExists:
					self.aktyw_ente2 += dt
					if self.aktyw_ente2<10:
						baseImage.paste(self.szukanie, (0, 0))	
						if cab == 1:
							self.print_center(draw, "Kabina A", 55,16, self.fontv20b, tableTextColor)
						if cab == -1:
							self.print_center(draw, "Kabina B", 55,16, self.fontv20b, tableTextColor)
						self.print_center(draw, czas, 732,16, self.fontv20b, tableTextColor)							
					else:	
						if self.awaria_ente == True:	
							baseImage.paste(self.error, (0, 0))							
							if cab == 1:
								self.print_center(draw, "Kabina A", 55,16, self.fontv20b, tableTextColor)
							if cab == -1:
								self.print_center(draw, "Kabina B", 55,16, self.fontv20b, tableTextColor)
							self.print_center(draw, czas, 732,16, self.fontv20b, tableTextColor)							
							return baseImage
						if self.awaria_ente2 == True:		
							baseImage.paste(self.error2, (0, 0))							
							if cab == 1:
								self.print_center(draw, "Kabina A", 55,16, self.fontv20b, tableTextColor)
							if cab == -1:
								self.print_center(draw, "Kabina B", 55,16, self.fontv20b, tableTextColor)
							self.print_center(draw, czas, 732,16, self.fontv20b, tableTextColor)		
							return baseImage					
						if self.awaria_ente2 == False and self.awaria_ente == False:				
							baseImage.paste(baseImage, (0,0))								
							tableTotalY = 0
							for i in range(state["train_stationstart"] - 1, len(tableData)):
								tableRowData = tableData[i]
								tableRowHeight = 48
								if i == 0 or not (tableRowData["vmax"] is None):
									tableRowHeight = 72

								# wypelnienie
								# na zielono (uzywane przez GPS zamiast kropki)
								color = ente_zielony if delay == 0 else ente_czerwony
								if i + 1 == tableGPSIndex:
									tableDraw.rectangle(combVec(addVec(tableOffset, (tableRows[3], tableTotalY)), addVec(tableOffset, (tableRows[-1], tableTotalY + tableRowHeight))), fill = color)
								elif i == state["train_stationstart"] - 1 and tableGPSIndex == 0:
									tableDraw.line([addVec(tableOffset, (tableRows[3], tableTotalY + 2)), addVec(tableOffset, (tableRows[-1], tableTotalY + 2))], fill = color, width = 3)

								# linie poziome
								if i == 0 or not (tableRowData["id12"] is None):
									tableDraw.line([addVec(tableOffset, (tableRows[0], tableTotalY)), addVec(tableOffset, (tableRows[1], tableTotalY))], fill = tableTextColor, width = 1)
								if i == 0 or not (tableRowData["vkm"] is None):
									tableDraw.line([addVec(tableOffset, (tableRows[1], tableTotalY)), addVec(tableOffset, (tableRows[3], tableTotalY))], fill = tableTextColor, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[3], tableTotalY)), addVec(tableOffset, (tableRows[-1], tableTotalY))], fill = tableTextColor, width = 1)
								# miejsce na nazwe rozkladu
								if i == 0:
									tableDraw.line([addVec(tableOffset, (tableRows[4] + 16, tableTotalY + (tableRowHeight * (1 / 3.0)))), addVec(tableOffset, (tableRows[6] - 16, tableTotalY + (tableRowHeight * (1 / 3.0))))], fill = tableTextColor, width = 1)
									tableDraw.line([addVec(tableOffset, (tableRows[4] + 16, tableTotalY + (tableRowHeight * (2 / 3.0)))), addVec(tableOffset, (tableRows[6] - 16, tableTotalY + (tableRowHeight * (2 / 3.0))))], fill = tableTextColor, width = 1)
								# przedzielenie czasow jazdy
								if i > 0:
									tableDraw.line([addVec(tableOffset, (tableRows[5], tableTotalY + (tableRowHeight / 2))), addVec(tableOffset, (tableRows[6], tableTotalY + (tableRowHeight / 2)))], fill = tableTextColor, width = 1)
								# przedzielenie rubryk obslugi trakcyjnej
								#if not tableShortMode:
								color = tableTextColor
								if not tableRowData["trainChange"]:
									color = tableGrayTextColor
								tableDraw.line([addVec(tableOffset, (tableRows[6], tableTotalY + (tableRowHeight * (1 / 3.0)))), addVec(tableOffset, (tableRows[7], tableTotalY + (tableRowHeight * (1 / 3.0))))], fill = color, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[6], tableTotalY + (tableRowHeight * (2 / 3.0)))), addVec(tableOffset, (tableRows[7], tableTotalY + (tableRowHeight * (2 / 3.0))))], fill = color, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[7], tableTotalY + (tableRowHeight / 2))), addVec(tableOffset, (tableRows[9], tableTotalY + (tableRowHeight / 2)))], fill = color, width = 1)

								# linie pionowe
								tableDraw.line([addVec(tableOffset, (tableRows[0], tableTotalY)), addVec(tableOffset, (tableRows[0], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[1], tableTotalY)), addVec(tableOffset, (tableRows[1], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[2], tableTotalY)), addVec(tableOffset, (tableRows[2], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 3)
								tableDraw.line([addVec(tableOffset, (tableRows[3], tableTotalY)), addVec(tableOffset, (tableRows[3], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 1)
								if tableRowData["tracks"] == 1:
									tableDraw.line([addVec(tableOffset, (tableRows[4], tableTotalY)), addVec(tableOffset, (tableRows[4], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 7)
								elif tableRowData["tracks"] == 2:
									tableDraw.line([addVec(tableOffset, (tableRows[4] - 2.5, tableTotalY)), addVec(tableOffset, (tableRows[4] - 2.5, tableTotalY + tableRowHeight))], fill = tableTextColor, width = 2)
									tableDraw.line([addVec(tableOffset, (tableRows[4] + 2.5, tableTotalY)), addVec(tableOffset, (tableRows[4] + 2.5, tableTotalY + tableRowHeight))], fill = tableTextColor, width = 2)
								if i == 0:
									tableDraw.line([addVec(tableOffset, (tableRows[5], tableTotalY)), addVec(tableOffset, (tableRows[5], tableTotalY + (tableRowHeight * (1 / 3.0))))], fill = tableTextColor, width = 1)
									tableDraw.line([addVec(tableOffset, (tableRows[5], tableTotalY + (tableRowHeight * (2 / 3.0)))), addVec(tableOffset, (tableRows[5], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 1)
								else:
									tableDraw.line([addVec(tableOffset, (tableRows[5], tableTotalY)), addVec(tableOffset, (tableRows[5], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[6], tableTotalY)), addVec(tableOffset, (tableRows[6], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 1)
								color = tableTextColor
							#	if not tableShortMode:
								if not tableRowData["trainChange"]:
									color = tableGrayTextColor
								tableDraw.line([addVec(tableOffset, (tableRows[7], tableTotalY)), addVec(tableOffset, (tableRows[7], tableTotalY + tableRowHeight))], fill = color, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[8], tableTotalY)), addVec(tableOffset, (tableRows[8], tableTotalY + tableRowHeight))], fill = color, width = 1)
								tableDraw.line([addVec(tableOffset, (tableRows[9], tableTotalY)), addVec(tableOffset, (tableRows[9], tableTotalY + tableRowHeight))], fill = tableTextColor, width = 1)

								# tekst
								# pierwsze 3 rubryki
								if not (tableRowData["id12"] is None):
									tableDraw.text(addVec(tableOffset, (((tableRows[0] + tableRows[1]) / 2) - (tableDraw.textsize(tableRowData["id12"], font = self.font1)[0] / 2), tableTotalY + 4)), tableRowData["id12"], font = self.font1, fill = tableTextColor)
								if not (tableRowData["vkm"] is None):
									tableDraw.text(addVec(tableOffset, (tableRows[1] + 4, tableTotalY + 4)), kmText(tableRowData["vkm"]), font = self.font1, fill = tableTextColor)
								if not (tableRowData["vmax"] is None):
									tableDraw.text(addVec(tableOffset, (((tableRows[2] + tableRows[3]) / 2) - (tableDraw.textsize(str(tableRowData["vmax"]), font = self.font2b)[0] / 2), tableTotalY + 2)), str(tableRowData["vmax"]), font = self.font2b, fill = tableTextColor)
								# 4 rubryka - nazwa stacji
								text = tableRowData["name"]
								if i > 0 and tableRowData["ah"] != -1:
									text += " ; ph"
								font = self.font3
								if tableRowData["station"]:
									font = self.font3b
								tableDraw.text(addVec(tableOffset, (tableRows[3] + 4, tableTotalY + 2)), text, font = font, fill = tableTextColor)
								text = kmText(tableRowData["km"])
								if not (tableRowData["id12"] is None):
									text = "0." + tableRowData["id12"] + "/" + text
								tableDraw.text(addVec(tableOffset, (tableRows[3] + 4, (tableTotalY + tableRowHeight) - 22)), text, font = self.font3, fill = tableTextColor)
								tableDraw.text(addVec(tableOffset, ((tableRows[4] - tableDraw.textsize(tableRowData["eq"], self.font3)[0]) - 8, (tableTotalY + tableRowHeight) - 22)), tableRowData["eq"], font = self.font3, fill = tableTextColor)
								# 5 rubryka - godziny przyjazdu i odjazdu
								font = self.font3b
								if tableRowData["ah"] == -1:
									font = self.font3
								if i == 0:
									# numer pociagu
									tableDraw.line([addVec(tableOffset, (tableRows[4] + 8, tableTotalY + 12)), addVec(tableOffset, (tableRows[5] - 8, tableTotalY + 12))], fill = tableTextColor, width = 1)
									tableDraw.text(addVec(tableOffset, (((tableRows[4] + tableRows[6]) / 2) - (tableDraw.textsize(tableTrainName, font = self.font1b)[0] / 2), (tableTotalY + (tableRowHeight / 2)) - 7)), tableTrainName, font = self.font1b, fill = tableTextColor)
								elif tableRowData["ah"] == -1:
									# przelot (kreska)
									tableDraw.line([addVec(tableOffset, ((tableRows[4] + tableRows[5]) / 2, tableTotalY + 2)), addVec(tableOffset, ((tableRows[4] + tableRows[5]) / 2, tableTotalY + 22))], fill = tableTextColor, width = 1)
								else:
									# normalny przyjazd
									tableDraw.text(addVec(tableOffset, (((tableRows[4] + tableRows[5]) / 2) - (tableDraw.textsize(timeText(tableRowData["ah"], tableRowData["am"]), font = font)[0] / 2), tableTotalY + 2)), timeText(tableRowData["ah"], tableRowData["am"]), font = font, fill = tableTextColor)
									# ulamek minuty
									if tableRowData["ahalf"] > 0:
										tableDraw.text(addVec(tableOffset, (((tableRows[4] + tableRows[5]) / 2) + (tableDraw.textsize(timeText(tableRowData["ah"], tableRowData["am"]), font = font)[0] / 2), tableTotalY - 2)), str(tableRowData["ahalf"]), font = self.font2, fill = tableTextColor)
								# odjazd
								tableDraw.text(addVec(tableOffset, (((tableRows[4] + tableRows[5]) / 2) - (tableDraw.textsize(timeText(tableRowData["dh"], tableRowData["dm"]), font = font)[0] / 2), (tableTotalY + tableRowHeight) - 22)), timeText(tableRowData["dh"], tableRowData["dm"]), font = font, fill = tableTextColor)
								# ulamek minuty
								if tableRowData["dhalf"] > 0:
									tableDraw.text(addVec(tableOffset, (((tableRows[4] + tableRows[5]) / 2) + (tableDraw.textsize(timeText(tableRowData["dh"], tableRowData["dm"]), font = font)[0] / 2), (tableTotalY + tableRowHeight) - 26)), str(tableRowData["dhalf"]), font = self.font2, fill = tableTextColor)
								# 6 rubryka - czasy jazdy
								if i > 0:
									tableDraw.text(addVec(tableOffset, (tableRows[5] + 4, tableTotalY + 6)), str(tableRowData["jtime"]), font = self.font0, fill = tableTextColor)
									tableDraw.text(addVec(tableOffset, (tableRows[5] + 4, (tableTotalY + tableRowHeight) - 18)), str(tableRowData["jtimeShort"]), font = self.font0, fill = tableTextColor)
								#if not tableShortMode:
								# 7 i 8 rubryka wyszarzala gdy nie ma zmiany wzgledem poprzedniej
								color = tableTextColor
								if not tableRowData["trainChange"]:
									color = tableGrayTextColor
								# 7 rubryka - obsluga trakcyjna
								for i in range(3):
									if tableRowData["veh" + str(i + 1)] == None:
										break
									tableDraw.text(addVec(tableOffset, (((tableRows[6] + tableRows[7]) / 2) - (tableDraw.textsize(tableRowData["veh" + str(i + 1)], font = self.font1)[0] / 2), (tableTotalY + (tableRowHeight * (((i * 2) + 1) / 6.0))) - 6)), tableRowData["veh" + str(i + 1)], font = self.font1, fill = color)
								# 8 rubryka - masa, vmax, dlugosc, % masy hamowania
								tableDraw.text(addVec(tableOffset, (((tableRows[7] + tableRows[8]) / 2) - (tableDraw.textsize(str(int(tableRowData["vehweight"])), font = self.font3)[0] / 2), (tableTotalY + (tableRowHeight * (1 / 4.0))) - 12)), str(int(tableRowData["vehweight"])), font = self.font3, fill = color)
								tableDraw.text(addVec(tableOffset, (((tableRows[7] + tableRows[8]) / 2) - (tableDraw.textsize(str(int(tableRowData["vehvmax"])), font = self.font3)[0] / 2), (tableTotalY + (tableRowHeight * (3 / 4.0))) - 12)), str(int(tableRowData["vehvmax"])), font = self.font3, fill = color)
								tableDraw.text(addVec(tableOffset, (((tableRows[8] + tableRows[9]) / 2) - (tableDraw.textsize(str(int(tableRowData["vehlength"])), font = self.font3)[0] / 2), (tableTotalY + (tableRowHeight * (1 / 4.0))) - 12)), str(int(tableRowData["vehlength"])), font = self.font3, fill = color)
								tableDraw.text(addVec(tableOffset, (((tableRows[8] + tableRows[9]) / 2) - (tableDraw.textsize(str(int(tableRowData["vehbrake"])), font = self.font3)[0] / 2), (tableTotalY + (tableRowHeight * (3 / 4.0))) - 12)), str(int(tableRowData["vehbrake"])), font = self.font3, fill = color)

								tableTotalY += tableRowHeight
								# dalej i tak nie widzimy - optymalizacja
								if tableTotalY > tableSize[1]:
									break
							# domkniecie tabelki
							tableDraw.line([addVec(tableOffset, (tableRows[0], tableTotalY)), addVec(tableOffset, (tableRows[-1], tableTotalY))], fill = tableTextColor, width = 1)
							baseImage.paste(tableImage, tableBackOffset)

							# informacja tymczasowa
							if "scenarion" in state:
								tableDraw.text((20, 80), u"Pobierz nowe exe\nz działu \"Na warsztacie\"\nJESZCZE RAZ\nw posiadanym wkradła\nsię literówka\nUNIEMOŻLIWIAJĄCA prawidłowe\ndziałanie ekranu!!!", font = self.fontv2b, fill = (255, 0, 0))													
						
				else: 
					baseImage.paste(self.ente_main,(0,0),self.ente_main)
					self.print_center(draw, czas, 732,16, self.fontv20b, tableTextColor)
					self.print_center(draw, "Wylogowany", 700,85, self.ente3, ente_zolty)
					self.print_center(draw, '%d' % speed, 660,188, self.ente3, ente_zolty)
					self.print_center(draw, "km/h", 700,188, self.ente3, ente_zolty)
					self.print_center(draw, "0.0 S", 668,222, self.ente3, ente_zolty)
					self.print_center(draw, "0.0 W", 668,254, self.ente3, ente_zolty)
					self.print_center(draw, self.woz, 72,516, self.ente3, tableTextColor)
					if state['master'] == 0:
						baseImage.paste(self.slave,(13,468),self.slave)	
					if pojazdy >= 2:
						self.print_center(draw, self.woz2, 202,516, self.ente3, tableTextColor)			
						baseImage.paste(self.slave,(139,468),self.slave)	
					if pojazdy == 3:
						self.print_center(draw, self.woz3, 327,516, self.ente3, tableTextColor)			
						baseImage.paste(self.slave,(264,468),self.slave)								

						
				if cab == 1:
					self.print_center(draw, "Kabina A", 55,16, self.fontv20b, tableTextColor)
				if cab == -1:
					self.print_center(draw, "Kabina B", 55,16, self.fontv20b, tableTextColor)
				self.print_center(draw, czas, 732,16, self.fontv20b, tableTextColor)


						
				tlo.paste(baseImage, (0,0))		

		else:
			self.aktyw_ente = 0
			self.aktyw_ente2 = 0
			self.nieaktyw_ente = -1
		# szansa na zbicie zepsucia jesli wlasnie wylaczono baterie
			if self.awaria_ente or self.awaria_ente2 and random() < 0.45:
				self.awaria_ente = False		
				self.awaria_ente2 = False					
		return tlo


	def get_vehicle_name(self, name):
		# zasada dzialania: ucinamy wszystkie literki na koncu (zostaje tylko to co jest do ostatniej cyfry)
		digits = "0123456789"
		n = 0
		for i in range(len(name)):
			if name[i] in digits:
				n = i
		return name[:n+1]

# globale do rozkladu jazdy
globalState = {}

tableShortMode = True # true dla AKL i AKM, false dla AKS; nie zmieniamy po zaladowaniu symulatora
tableGPSIndex = 1 # numer stacji przy ktorej jest zielona kropka, numerujemy od 1, 0 oznacza nigdzie
tableSize = (646, 451)
tableBackOffset = (5, 94)
tableOffset = (5, 5)
tableColor = (210, 210, 210) # zamienic ten i ten nizej miejscami jesli chcesz tryb nocny
tableTextColor = (0, 0, 0)
tableGrayTextColor = (105, 105, 105)
panelTextColor = (210, 210, 210)
tableRows = [32, 93, 159, 416, 551, 593, 628, ]
tableData = [
	# id12 - numer linii
	# vkm - kilometr dla nowej Vmax
	# vmax - nowa predkosc maksymalna
	# name - nazwa stacji
	# km - kilometr stacji
	# station - true jesli to stacja, false jesli przystanek lub posterunek odgalezny
	# eq - wyposazenie
	# tracks - liczba torow
	# ah, am, ahalf, dh, dm, dhalf -
	# pierwszy czlon: a - przyjazd, d - odjazd
	# drugi czlon: h - godzina, m - minuta, half - cyfra w indeksie gornym (0 = brak)
	# jtime - czas przejazdu
	# jtimeShort - czas skrocony przejazdu
	# trainChange - true na poczatku i na kazdej stacji gdzie zmienia sie sklad (dolaczamy, odlaczamy, zmieniamy)
	# ponizsze to od trakcyjnej
	# veh1 - pojazd 1
	# veh2 - pojazd 2
	# veh3 - pojazd 3
	# vehweight - masa
	# vehvmax - vmax
	# vehlength - dlugosc
	# vehbrake - % masy hamowania
	
	# przykladowe dane
	#{"id12":"191","vkm":19.71,"vmax":40,"name":u"Wisła Głębce","km":19.71,"station":True,"eq":"R2, H","ah":-1,"am":-1,"ahalf":0,"dh":13,"dm":43,"dhalf":0,"jtime":None,"jtimeShort":None},
	#{"id12":None,"vkm":None,"vmax":None,"name":u"Wisła Kopydło po","km":17.96,"station":False,"eq":"","ah":13,"am":46,"ahalf":5,"dh":13,"dm":47,"dhalf":0,"jtime":3.5,"jtimeShort":3},
	#{"id12":None,"vkm":None,"vmax":None,"name":u"Wisła Dziechc. po","km":16.241,"station":False,"eq":"","ah":13,"am":50,"ahalf":0,"dh":13,"dm":50,"dhalf":5,"jtime":3,"jtimeShort":2.9},
	#{"id12":None,"vkm":14,"vmax":60,"name":u"Wisła Uzdrowisko","km":14.61,"station":True,"eq":"R2, H","ah":13,"am":53,"ahalf":5,"dh":13,"dm":54,"dhalf":0,"jtime":3,"jtimeShort":2.8},
	#{"id12":None,"vkm":None,"vmax":None,"name":u"Wisła Obłaziec po","km":12.338,"station":False,"eq":"","ah":13,"am":59,"ahalf":0,"dh":13,"dm":59,"dhalf":5,"jtime":5,"jtimeShort":4.7},
	#{"id12":None,"vkm":None,"vmax":None,"name":u"Ustroń Polana m, po","km":9.662,"station":False,"eq":"R2, H","ah":14,"am":3,"ahalf":0,"dh":14,"dm":3,"dhalf":5,"jtime":3.5,"jtimeShort":3.4},
	#{"id12":None,"vkm":None,"vmax":None,"name":u"Ustroń Zdrój po","km":6.655,"station":False,"eq":"","ah":14,"am":7,"ahalf":5,"dh":14,"dm":8,"dhalf":0,"jtime":4,"jtimeShort":3.6}
]
tableTrainName = ""


# funkcje do rozkladu jazdy
def prepareTableData():
	state = globalState
	global tableData
	tableData = [] # czyscimy
	
	lastVmax = None # potrzebne nam jest to zeby co pozycje sprawdzac czy vmax sie zmienila, i jesli tak - to wprowadzic to do tabelki
	# nie mozemy tego zrobic uzyskujac dane z ostatniej kolumny, poniewaz brak zmiany oznaczony jest jako none, co spowodowaloby pojawienie sie tej samej predkosci co druga rubryke
	
	for i in range(state["train_stationcount"]):
		tableRowData = {}
		if i == 0:
			# NA POCZATEK WIELKIE SZAMYNSTWO!!! Numer linii generowany losowo!!! W dodatku z wyjatkami na nazwy niektorych scenerii!!!
			# Zakres 1-299, co prawda w rzeczywistosci jest do 999, ale powyzej 300 to juz raczej malutkie linie i lacznice
			# generowanie na podstawie 5 pierwszych znakow lacznie z dolarem, zeby sie numery linii nie roznily przy np. baltyk i baltyk_zima
			if state["scenario"][:5] == "$l053":
				tableRowData["id12"] = "53"
			elif state["scenario"][:9] == "$l61+l144":
				tableRowData["id12"] = "144"
			elif state["scenario"][:8] == "$linia61":
				tableRowData["id12"] = "61"
			else:
				tableRowData["id12"] = str(tryInt((int(hash(state["scenario"][:5])) % 299) + 1))
		else:
			tableRowData["id12"] = None
		if i == 0 or state["train_station" + str(i + 1) + "_vmax"] != lastVmax:
			tableRowData["vkm"] = state["train_station" + str(i + 1) + "_lctn"]
			tableRowData["vmax"] = int(state["train_station" + str(i + 1) + "_vmax"])
		else:
			tableRowData["vkm"] = None
			tableRowData["vmax"] = None
		lastVmax = state["train_station" + str(i + 1) + "_vmax"]
		tableRowData["name"] = removeUnderscores(state["train_station" + str(i + 1) + "_name"])
		tableRowData["km"] = state["train_station" + str(i + 1) + "_lctn"]
		tableRowData["station"] = not (tableRowData["name"][:2] == "po" or tableRowData["name"][:4] == "podg" or tableRowData["name"][-2:] == "po" or tableRowData["name"][-4:] == "podg") # wyszukac wszystkie mozliwe koncowki
		tableRowData["eq"] = state["train_station" + str(i + 1) + "_fclt"]
		tableRowData["tracks"] = state["train_station" + str(i + 1) + "_tracks"]
		tableRowData["ah"] = state["train_station" + str(i + 1) + "_ah"]
		tableRowData["am"] = int(state["train_station" + str(i + 1) + "_am"])
		tableRowData["ahalf"] = int(round((state["train_station" + str(i + 1) + "_am"] * 10) % 10))
		tableRowData["dh"] = state["train_station" + str(i + 1) + "_dh"]
		tableRowData["dm"] = int(state["train_station" + str(i + 1) + "_dm"])
		tableRowData["dhalf"] = int(round((state["train_station" + str(i + 1) + "_dm"] * 10) % 10))
		if i == 0:
			tableRowData["jtime"] = None
			tableRowData["jtimeShort"] = None
		else:
			if tableRowData["ah"] == -1:
				tableRowData["jtime"] = tryInt(journeyTime(tableData[-1]["dh"], tableData[-1]["dm"] + (tableData[-1]["dhalf"] * 0.1), tableRowData["dh"], tableRowData["dm"] + (tableRowData["dhalf"] * 0.1)))
			else:
				tableRowData["jtime"] = tryInt(journeyTime(tableData[-1]["dh"], tableData[-1]["dm"] + (tableData[-1]["dhalf"] * 0.1), tableRowData["ah"], tableRowData["am"] + (tableRowData["ahalf"] * 0.1)))
			tableRowData["jtimeShort"] = tryInt(tableRowData["jtime"] - (((int(hash(tableRowData["name"])) % 5) * 0.1) + 0.1)) # szamynstwo do czasu rozszerzenia funkcji rozkladow jazdy
		tableRowData["trainChange"] = i == 0
		vehicles = state["train_enginetype"].split("_")
		for i in range(3):
			if len(vehicles) > i:
				tableRowData["veh" + str(i + 1)] = vehicles[i]
			else:
				tableRowData["veh" + str(i + 1)] = None
		tableRowData["vehweight"] = state["train_engineload"]
		tableRowData["vehvmax"] = 120 # do zmiany przy kopiowaniu skryptu lub przy rozszerzeniu funkcji rozkladow
		tableRowData["vehlength"] = len(vehicles) * 64 # szamynstwo i postepowanie jak wyzej
		tableRowData["vehbrake"] = state["train_brakingmassratio"]
		tableData.append(tableRowData)


def addVec(vector1, vector2):
	return (vector1[0] + vector2[0], vector1[1] + vector2[1])

def combVec(vector1, vector2):
	return (vector1[0], vector1[1], vector2[0], vector2[1])

def timeText(hour, minute):
	return headZeros(hour, 2) + ":" + headZeros(minute, 2)

def journeyTime(hour1, minute1, hour2, minute2):
	return (((((hour2 - hour1) * 60) + (minute2 - minute1)) + 720) % 1440) - 720

def timeTextSecs(hour, minute, second):
	return headZeros(hour, 2) + ":" + headZeros(minute, 2) + ":" + headZeros(second, 2)

def journeyTimeSecs(hour1, minute1, second1, hour2, minute2, second2):
	return (((((hour2 - hour1) * 3600) + ((minute2 - minute1) * 60) + (second2 - second1)) + 43200) % 86400) - 43200

def tryInt(value):
	if value == int(value):
		return int(value)
	return value

def removeUnderscores(string):
	return string.replace("_", " ")

def trainNumber(trainName):
	digits = ("0", "1", "2", "3", "4", "5", "6", "7", "8", "9")
	for i in range(len(trainName)):
		if trainName[i:(i + 1)] in digits:
			return trainName[i:]
	# no digits?
	return ""

def kmText(km):
	return str(int(km)) + "." + headZeros(int((km * 1000) % 1000), 3)

def headZeros(value, digits):
	text = str(int(value))
	while len(text) < digits:
		text = "0" + text
	return text
